<?php
// modify_user.php
// action=add|remove  user_id=...  uid=...
// Accepts GET or POST.

header("Content-Type: application/json; charset=utf-8");

$BASE = __DIR__ . "/database";
$USERS = $BASE . "/users";
$IDX = $BASE . "/index";
foreach ([$USERS, $IDX] as $d) if (!is_dir($d)) mkdir($d, 0777, true);

function read_input(){ $in=$_POST; if(empty($in)){ $raw=@file_get_contents("php://input"); $json=@json_decode($raw,true); if(is_array($json)) $in=$json;} if(empty($in)) $in=$_GET; return $in?:[]; }
function normal_uid($s){ return strtoupper(preg_replace('/\s+/', '', (string)$s)); }
function atomic_save($path,$data){ $tmp=$path.'.tmp'; if(file_put_contents($tmp,json_encode($data,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES))===false) return false; rename($tmp,$path); return true; }
function load_index($p){ if(!file_exists($p)) return []; $c=@file_get_contents($p); $j=@json_decode($c,true); return is_array($j)?$j:[]; }

$in = read_input();
$action = isset($in['action']) ? strtolower(trim((string)$in['action'])) : null;
$user_id = isset($in['user_id']) ? trim((string)$in['user_id']) : null;
$uid_raw = isset($in['uid']) ? trim((string)$in['uid']) : null;

if (!$action || !$user_id || !$uid_raw) {
    http_response_code(400);
    echo json_encode(["status"=>"error","message"=>"action, user_id, uid required"]);
    exit;
}
if (!in_array($action, ['add','remove'])) {
    http_response_code(400);
    echo json_encode(["status"=>"error","message"=>"action must be 'add' or 'remove'"]);
    exit;
}

$uid = normal_uid($uid_raw);
$user_path = "$USERS/user-{$user_id}.json";
if (!file_exists($user_path)) {
    http_response_code(404);
    echo json_encode(["status"=>"error","message"=>"user not found"]);
    exit;
}
$user = @json_decode(@file_get_contents($user_path), true);
if (!is_array($user)) {
    http_response_code(500);
    echo json_encode(["status"=>"error","message"=>"invalid user file"]);
    exit;
}

// Load index
$names_p = "$IDX/names.json"; $admnos_p = "$IDX/admnos.json"; $uids_p = "$IDX/uids.json";
$names = load_index($names_p); $admnos = load_index($admnos_p); $uids = load_index($uids_p);

if ($action === 'add') {
    // conflict: uid assigned to other user
    if (isset($uids[$uid]) && $uids[$uid] !== $user_id) {
        http_response_code(409);
        echo json_encode(["status"=>"error","message"=>"uid assigned to another user","assigned_to"=>$uids[$uid]]);
        exit;
    }
    if (!in_array($uid, $user['uids'] ?? [])) $user['uids'][] = $uid;
    $user['updated_at'] = date("c");
    // save and update index
    $tmp = $user_path . ".tmp";
    if (file_put_contents($tmp, json_encode($user, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES)) === false) {
        http_response_code(500); echo json_encode(["status"=>"error","message"=>"failed to save user"]); exit;
    }
    rename($tmp, $user_path);
    $uids[$uid] = $user_id; atomic_save($uids_p, $uids);
    echo json_encode(["status"=>"ok","message"=>"uid added","user_id"=>$user_id,"uids"=>$user['uids']]);
    exit;
}

if ($action === 'remove') {
    $found = false; $new = [];
    foreach ($user['uids'] ?? [] as $u) { if ($u === $uid) { $found = true; continue; } $new[] = $u; }
    if (!$found) { http_response_code(404); echo json_encode(["status"=>"error","message"=>"uid not found for user"]); exit; }
    $user['uids'] = array_values($new);
    $user['updated_at'] = date("c");
    $tmp = $user_path . ".tmp";
    if (file_put_contents($tmp, json_encode($user, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES)) === false) { http_response_code(500); echo json_encode(["status"=>"error","message"=>"failed to save user"]); exit; }
    rename($tmp, $user_path);
    if (isset($uids[$uid]) && $uids[$uid] === $user_id) { unset($uids[$uid]); atomic_save($uids_p, $uids); }
    echo json_encode(["status"=>"ok","message"=>"uid removed","user_id"=>$user_id,"uids"=>$user['uids']]);
    exit;
}
