<?php
// Allow access from any origin
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// Base API endpoint (fixed for batches)
$api_base = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/batches";

// Get the full query string from the request
$query_string = isset($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : '';

if (empty($query_string)) {
    echo json_encode([
        "success" => false,
        "error" => "No query parameters provided. Example: ?page=1&limit=12&q=arjuna%20jee%202026"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Build full API URL
$api_url = $api_base . '?' . $query_string;

// Build proxied URL with CORS proxy
$cors_base = "https://cors.hideme.eu.org/?url=";
$proxied_url = $cors_base . urlencode($api_url);

// Setup headers for cURL
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*"
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $proxied_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // disable SSL verify just in case

// Execute cURL request
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode([
        "success" => false,
        "error" => "cURL error: " . curl_error($ch)
    ], JSON_PRETTY_PRINT);
    curl_close($ch);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    echo json_encode([
        "success" => false,
        "error" => "API request failed with HTTP code $http_code"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Parse JSON response
$data = json_decode($response, true);

if (json_last_error() === JSON_ERROR_NONE) {
    echo json_encode([
        "success" => true,
        "data" => $data
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid JSON response from API",
        "raw" => $response
    ], JSON_PRETTY_PRINT);
}
