<?php
// Allow access from any origin (CORS)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Get query parameters
$batch_id = isset($_GET['batch_id']) ? trim($_GET['batch_id']) : '';
$schedule_id = isset($_GET['schedule_id']) ? trim($_GET['schedule_id']) : '';

// Validate parameters
if (empty($batch_id) || empty($schedule_id)) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid request. Use format: file_token_batch.php?batch_id=<batch_id>&schedule_id=<schedule_id>"
    ]);
    exit();
}

// Base API URL
$base_url = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/url";

// Build API URL
$api_url = $base_url . "?batch_id=" . urlencode($batch_id) . "&schedule_id=" . urlencode($schedule_id);

// Fetch data from API
$response = @file_get_contents($api_url);

// Handle fetch errors
if ($response === FALSE) {
    echo json_encode([
        "error" => true,
        "message" => "Failed to fetch data from API."
    ]);
    exit();
}

// Decode JSON from API
$data = json_decode($response, true);

// Handle JSON parse errors
if ($data === null) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid JSON response from API."
    ]);
    exit();
}

// Success — return API response
echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
