<?php
header('Content-Type: application/json');

// Allow browser to call your script from anywhere
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Get the batch_id from the URL path
$path_info = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : null;

if (!$path_info) {
    echo json_encode([
        "success" => false,
        "error"   => "No batch_id provided. Use like: script.php/<batch_id>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$batch_id = $path_info;

// Build the CORS proxy URL (protects real API)
$cors_base = "https://cors.hideme.eu.org/?url=";
$real_url = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/batch/" . urlencode($batch_id);
$url = $cors_base . urlencode($real_url);

// Setup headers for the API request
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*"
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // ignore SSL issues if any

// Execute
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode([
        "success" => false,
        "error"   => "cURL error: " . curl_error($ch)
    ], JSON_PRETTY_PRINT);
    curl_close($ch);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// If API returns a non-200 status code
if ($http_code !== 200) {
    echo json_encode([
        "success" => false,
        "error"   => "API request failed with HTTP code $http_code"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Try to parse JSON
$data = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo json_encode([
        "success" => true,
        "data"    => $data
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid JSON response from API",
        "raw"     => $response
    ], JSON_PRETTY_PRINT);
}
?>
