<?php
// ==== CORS Headers ====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// ==== Get path parameters ====
// Example:
// https://yourdomain.com/proxy.php/676e4dee1ec923bc192f38c9/physics-931643/686e8048062305d5f590067d
$path = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : '';
$parts = explode('/', $path);

// Expect exactly 3 parts: batch_id, subject_id, schedule_id
if (count($parts) !== 3) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid request. Use: /<batch_id>/<subject_id>/<schedule_id>"
    ]);
    exit();
}

$batch_id    = $parts[0];
$subject_id  = $parts[1];
$schedule_id = $parts[2];

// ==== Base API URL ====
$base_url = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/batch";

// ==== Build final API URL ====
$api_url = $base_url . "/" . urlencode($batch_id)
    . "/subject/" . urlencode($subject_id)
    . "/schedule/" . urlencode($schedule_id)
    . "/content";

// ==== Setup cURL ====
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)",
    "Accept: application/json, text/plain, */*"
]);

$response = curl_exec($ch);

// ==== Handle cURL errors ====
if (curl_errno($ch)) {
    echo json_encode([
        "error" => true,
        "message" => "cURL Error: " . curl_error($ch)
    ]);
    curl_close($ch);
    exit();
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// ==== Handle HTTP errors ====
if ($http_code !== 200) {
    echo json_encode([
        "error" => true,
        "message" => "API request failed with HTTP code $http_code"
    ]);
    exit();
}

// ==== Decode API response ====
$data = json_decode($response, true);

// If JSON decoding fails
if ($data === null) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid JSON response from API",
        "raw" => $response
    ]);
    exit();
}

// ==== Return JSON to client ====
echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
?>
