<?php
// Allow access from any origin (CORS)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Get the path after the script name
$path = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : '';
$parts = explode('/', $path);

// Expect exactly 2 parts: batch_id and schedule_id
if (count($parts) !== 2) {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request. Use format: /file_token_batch.php/<batch_id>/<schedule_id>"
    ]);
    exit();
}

$batch_id = $parts[0];
$schedule_id = $parts[1];

// Base API URL
$base_url = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/url";

// Build API URL
$api_url = $base_url . "?batch_id=" . urlencode($batch_id) . "&schedule_id=" . urlencode($schedule_id);

// Fetch data from API
$response = @file_get_contents($api_url);

// Handle fetch errors
if ($response === FALSE) {
    echo json_encode([
        "success" => false,
        "error" => "Failed to fetch data from API."
    ]);
    exit();
}

// Decode JSON from API
$data = json_decode($response, true);

// Handle JSON parse errors or missing keys
if ($data === null) {
    echo json_encode([
        "success" => false,
        "error" => "Invalid JSON response from API."
    ]);
    exit();
}

if (!isset($data['signed_url']) || !isset($data['video_id'])) {
    echo json_encode([
        "success" => false,
        "error" => "API response missing 'signed_url' or 'video_id'.",
        "raw_response" => $data
    ]);
    exit();
}

// Encode values for URL
$encoded_signed_url = urlencode($data['signed_url']);
$encoded_video_id   = urlencode($data['video_id']);

// Build the final player URL
$player_url = "https://pwthor.site/pwplayer.html?encrypted={$encoded_signed_url}&iv={$encoded_video_id}";

// Return as JSON
echo json_encode([
    "success" => true,
    "player_url" => $player_url
], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
