<?php
// Allow CORS for all domains
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header('Content-Type: application/json');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// Get batch_id and subject_id from URL path
// Example: https://yourdomain.com/script.php/676e4dee1ec923bc192f38c9/maths-640659
$path_info = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : null;

if (!$path_info) {
    echo json_encode([
        "success" => false,
        "error"   => "No batch_id or subject_id provided. Use like: script.php/<batch_id>/<subject_id>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$parts = explode('/', $path_info);

if (count($parts) < 2) {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid format. Use like: script.php/<batch_id>/<subject_id>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$batch_id   = $parts[0];
$subject_id = $parts[1];

// Base API URL (no external CORS proxy)
$real_url = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/batch/" . urlencode($batch_id) . "/subject/" . urlencode($subject_id) . "/topics";

// Setup headers
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*"
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $real_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Execute request
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode([
        "success" => false,
        "error"   => "cURL error: " . curl_error($ch)
    ], JSON_PRETTY_PRINT);
    curl_close($ch);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// If API returns a non-200 status code
if ($http_code !== 200) {
    echo json_encode([
        "success" => false,
        "error"   => "API request failed with HTTP code $http_code"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Try to parse JSON
$data = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo json_encode([
        "success" => true,
        "data"    => $data
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid JSON response from API",
        "raw"     => $response
    ], JSON_PRETTY_PRINT);
}
?>
