<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); 
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

// Handle OPTIONS request (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Get path parts from URL
// Example: https://yourdomain.com/script.php/676e4dee1ec923bc192f38c9/maths-640659/67fa0bfa33882ea1b7089a82/videos
$path_info = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : null;

if (!$path_info) {
    echo json_encode([
        "success" => false,
        "error"   => "No parameters provided. Use like: script.php/<batch_id>/<subject_id>/<topic_id>/<content_type>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$parts = explode('/', $path_info);

if (count($parts) < 4) {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid format. Use like: script.php/<batch_id>/<subject_id>/<topic_id>/<content_type>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$batch_id     = $parts[0];
$subject_id   = $parts[1];
$topic_id     = $parts[2];
$content_type = $parts[3]; // e.g., videos, notes, quizzes, etc.

// Direct API URL (no CORS proxy)
$real_url  = "https://pw-api2-9bac5f87cf60.herokuapp.com/api/batch/" 
    . urlencode($batch_id) . "/subject/" 
    . urlencode($subject_id) . "/topic/" 
    . urlencode($topic_id) . "/all-contents?type=" 
    . urlencode($content_type);

// Setup headers
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*"
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $real_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode([
        "success" => false,
        "error"   => "cURL error: " . curl_error($ch)
    ], JSON_PRETTY_PRINT);
    curl_close($ch);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// If API returns a non-200 status code
if ($http_code !== 200) {
    echo json_encode([
        "success" => false,
        "error"   => "API request failed with HTTP code $http_code"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Try to parse JSON
$data = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo json_encode([
        "success" => true,
        "data"    => $data
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid JSON response from API",
        "raw"     => $response
    ], JSON_PRETTY_PRINT);
}
?>
