<?php
// Allow access from any origin
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// Inner API endpoint (real target)
$inner_api_base = "https://api.pwthor.site/api/batches";

// Get query string from the request
$query_string = $_SERVER['QUERY_STRING'] ?? '';

if (empty($query_string)) {
    echo json_encode([
        "success" => false,
        "error" => "No query parameters provided. Example: ?page=1&limit=12"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Build full inner API URL
$inner_api_url = $inner_api_base . '?' . $query_string;

// Encode for proxy
$encoded_url = rawurlencode($inner_api_url);

// Wrap with cors.hideme.eu.org
$api_url = "https://cors.hideme.eu.org/?url=" . $encoded_url;

// Browser-like headers
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*",
    "Accept-Language: en-US,en;q=0.9",
    "Cache-Control: no-cache"
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Only allow encodings supported by libcurl
curl_setopt($ch, CURLOPT_ENCODING, "gzip, deflate");

// follow redirects
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

// timeouts
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 8);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);

// SSL verify
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

// include headers
curl_setopt($ch, CURLOPT_HEADER, true);

$raw = curl_exec($ch);
$errno = curl_errno($ch);
$errstr = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
curl_close($ch);

// cURL-level error
if ($errno !== 0) {
    echo json_encode([
        "success" => false,
        "error" => "cURL error: ({$errno}) {$errstr}"
    ], JSON_PRETTY_PRINT);
    exit;
}

// split headers/body
$headers_raw = '';
$body = $raw;
if ($raw !== false && $header_size > 0) {
    $headers_raw = substr($raw, 0, $header_size);
    $body = substr($raw, $header_size);
}

// non-200 response
if ($http_code !== 200) {
    echo json_encode([
        "success" => false,
        "error" => "API request failed with HTTP code {$http_code}",
        "http_code" => $http_code,
        "headers" => $headers_raw,
        "raw" => $body
    ], JSON_PRETTY_PRINT);
    exit;
}

// decode JSON
$data = json_decode($body, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "success" => false,
        "error" => "Invalid JSON response from API",
        "json_error" => json_last_error_msg(),
        "headers" => $headers_raw,
        "raw" => $body
    ], JSON_PRETTY_PRINT);
    exit;
}

// success
echo json_encode([
    "success" => true,
    "http_code" => 200,
    "data" => $data
], JSON_PRETTY_PRINT);
