<?php
// ==== CORS Headers ====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Credentials: true");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// ==== Get path parameters ====
// Example:
// https://yourdomain.com/proxy.php/676e4dee1ec923bc192f38c9/physics-931643/67fa1b6b8c78853f0a489af4
$path = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : '';
$parts = explode('/', $path);

// Expect at least 3 parts (batch_id, subject_id, topic_id)
if (count($parts) < 3) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid request. Use: /<batch_id>/<subject_id>/<topic_id>"
    ]);
    exit();
}

$batch_id   = $parts[0];
$subject_id = $parts[1];
$topic_id   = $parts[2];

// ==== Base API URL ====
$base_api = "https://api.pwthor.site/api/batch";

// ==== Build final API URL ====
// Example final: 
// https://api.pwthor.site/api/batch/{batch_id}/subject/{subject_id}/topic/{topic_id}/all-contents?type=notes
$api_url = $base_api . "/" . urlencode($batch_id)
    . "/subject/" . urlencode($subject_id)
    . "/topic/" . urlencode($topic_id)
    . "/all-contents?type=DppVideos";

// ==== Optional: wrap with CORS proxy ====
$proxy_url = "https://cors.hideme.eu.org/?url=" . urlencode($api_url);

// ==== Setup cURL ====
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $proxy_url);  // <-- use proxy
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*",
    "Accept-Language: en-GB,en-US;q=0.9,en;q=0.8,hi;q=0.7",
    "Cache-Control: no-cache",
    "Pragma: no-cache"
]);

$response = curl_exec($ch);

// ==== Handle cURL errors ====
if (curl_errno($ch)) {
    echo json_encode([
        "error" => true,
        "message" => "cURL Error: " . curl_error($ch)
    ]);
    curl_close($ch);
    exit();
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// ==== Handle HTTP errors ====
if ($http_code !== 200) {
    echo json_encode([
        "error" => true,
        "message" => "API request failed with HTTP code $http_code"
    ]);
    exit();
}

// ==== Decode API response ====
$data = json_decode($response, true);

// If JSON decoding fails
if ($data === null) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid JSON response from API",
        "raw" => $response
    ]);
    exit();
}

// ==== Return JSON to client ====
echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
?>
