<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Utility function to send error response
function send_json_error($message, $code = 400) {
    http_response_code($code);
    echo json_encode([
        "success" => false,
        "error"   => $message
    ], JSON_PRETTY_PRINT);
    exit;
}

// Get params (from query string or path)
$batch_id     = $_GET['batch_id']     ?? null;
$subject_slug = $_GET['subject_slug'] ?? null;
$schedule_id  = $_GET['schedule_id']  ?? null;

if (!$batch_id || !$subject_slug || !$schedule_id) {
    send_json_error("Missing required parameters: batch_id, subject_slug, schedule_id", 422);
}

// Construct target API URL
$targetUrl = "https://cors.hideme.eu.org/?url=" .
    "https://api.pwthor.site/api/batch/$batch_id/subject/$subject_slug/schedule/$schedule_id/content";

// Init cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $targetUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_ENCODING, "gzip, deflate, br, zstd"); // handle compression

// Headers (removed if-none-match, cleaned)
$headers = [
    "accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7",
    "accept-encoding: gzip, deflate, br, zstd",
    "accept-language: en-GB,en-US;q=0.9,en;q=0.8,hi;q=0.7",
    "cache-control: max-age=0",
    "cookie: cf_clearance=9pGflg1efDJMfinxU.Kae9sxjXOgKi0jCriGFxCBhl0-1754929872-1.2.1.1-bn071d8ZnFXqcue_ICjUn0y_eQQMMh79XXWfRH3sO.9Or4BwodZr6X9NTPDrEaBl7AryXuK44rBuTKFaEVFoesOsC3a947QNDE1ncYo7PZ1fQRZbOxDNhqecv4Lbgya8WicXgDyYJXTHfuST7EDnEmQTZg2401mkW4KwCiBbOeApaRi08UaFGAGBzqcveHkjr81eQ31wD.2FGGB8U99YD4EUt6x.pC.2SXE.7D9B4Bw",
    "sec-ch-ua: \"Not;A=Brand\";v=\"99\", \"Google Chrome\";v=\"139\", \"Chromium\";v=\"139\"",
    "sec-ch-ua-platform: \"Windows\"",
    "sec-fetch-site: none",
    "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36"
];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Execute request
$response = curl_exec($ch);

// Error handling
if (curl_errno($ch)) {
    send_json_error("cURL Error: " . curl_error($ch), 500);
}

$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

http_response_code($httpCode);
echo $response;
