<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Get params from user input (?batch=...&subject=...&topic=...&title=...)
$batch   = isset($_GET['batch'])   ? $_GET['batch']   : '';
$subject = isset($_GET['subject']) ? $_GET['subject'] : '';
$topic   = isset($_GET['topic'])   ? $_GET['topic']   : '';
$title   = isset($_GET['title'])   ? $_GET['title']   : '';

// If required params are missing
if (empty($batch) || empty($subject) || empty($topic) || empty($title)) {
    echo json_encode([
        "success" => false,
        "error" => "Missing required parameters (batch, subject, topic, title)"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Build API URL dynamically
$apiUrl = "https://api.pwthor.site/api/video/stream-info?batch=" . urlencode($batch)
        . "&subject=" . urlencode($subject)
        . "&topic=" . urlencode($topic)
        . "&title=" . urlencode($title);

// Add cors proxy
$url = "https://cors.hideme.eu.org/?url=" . urlencode($apiUrl);

// Cloudflare clearance cookie (update if expires)
$cookie = "cf_clearance=A1d0DbLgBZwT3XgUpFCvNhPeYS65hXz7wkYdICl9cBY-1756516926-1.2.1.1-5QU1uv2IbRJ6GLid36mRxbZXtEeuYctyYqe5Q3vv.7EyiyqrtiLWGx7R5YJyBR_BJIgUn55Lxr.qpVdQhTnpTHBVOTBMs4FVaaHhtRjD8PW9kYgMOPWYwdi.jgNZTDZnjvuiRLq6QcJiWLm7nezU2OkzFYk_N34KcaZ_DXNk1B9eSAp5a4u8t40sbvPni22TE3ipNzVSuuaSOGO6ClvIKPd6mlIeETHG4.yMfXvxYcg";

$headers = [
    "accept: application/json, text/plain, */*",
    "accept-encoding: gzip, deflate, br, zstd",
    "accept-language: en-GB,en-US;q=0.9,en;q=0.8,hi;q=0.7",
    "cache-control: no-cache",
    "cookie: $cookie",
    "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_ENCODING, "gzip, deflate, br, zstd");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Handle errors
if ($httpCode !== 200) {
    echo json_encode([
        "success" => false,
        "error" => "API returned status $httpCode",
        "response" => $response
    ], JSON_PRETTY_PRINT);
    exit;
}

// Decode API response
$data = json_decode($response, true);

// If invalid response
if (!isset($data['success']) || !$data['success']) {
    echo json_encode([
        "success" => false,
        "error" => "Invalid API response",
        "response" => $data
    ], JSON_PRETTY_PRINT);
    exit;
}

// Extract signed_url and video_id
$signedUrl = isset($data['signed_url']) ? urlencode($data['signed_url']) : '';
$videoId   = isset($data['video_id'])   ? urlencode($data['video_id'])   : '';

// Build final player url
$playerUrl = "https://pwthor.site/pwplayer.html?encrypted={$signedUrl}&iv={$videoId}";

// Final response
echo json_encode([
    "success" => true,
    "player_url" => $playerUrl
], JSON_PRETTY_PRINT);
