<?php
// Allow all origins, methods, and headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: *");
header("Content-Type: application/json");

// Handle OPTIONS preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Function to send a JSON error response
function send_json_error($message, $code = 400) {
    http_response_code($code);
    echo json_encode([
        "success" => false,
        "error"   => $message
    ], JSON_PRETTY_PRINT);
    exit;
}

// Get batch_id from URL path
$path_info = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : null;

if (!$path_info) {
    send_json_error("No batch_id provided. Use like: script.php/<batch_id>", 400);
}

$batch_id = $path_info;

// Build API URL (keep CORS proxy)
$cors_base = "https://cors.hideme.eu.org/?url=";
$real_url  = "https://api.pwthor.site/api/batch/" . urlencode($batch_id) . "/todays-schedule";
$url       = $cors_base . urlencode($real_url);

// Setup headers for API request
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*"
];

// Fetch via cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    send_json_error("cURL error: " . curl_error($ch), 500);
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// If API returns non-200 status
if ($http_code !== 200) {
    send_json_error("API request failed with HTTP code $http_code", $http_code);
}

// Try decoding JSON
$data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    send_json_error("Invalid JSON response from API", 502);
}

// Return success response
echo json_encode([
    "success" => true,
    "data"    => $data
], JSON_PRETTY_PRINT);
?>
