<?php
// === HEADERS (CORS + JSON) ===
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

// Handle OPTIONS request (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// === PATH INFO EXTRACTION ===
// Example: script.php/<batch_id>/<subject_id>/<topic_id>/<content_type>
$path_info = isset($_SERVER['PATH_INFO']) ? trim($_SERVER['PATH_INFO'], '/') : null;

if (!$path_info) {
    echo json_encode([
        "success" => false,
        "error"   => "No parameters provided. Use like: script.php/<batch_id>/<subject_id>/<topic_id>/<content_type>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$parts = explode('/', $path_info);
if (count($parts) < 4) {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid format. Use like: script.php/<batch_id>/<subject_id>/<topic_id>/<content_type>"
    ], JSON_PRETTY_PRINT);
    exit;
}

$batch_id     = $parts[0];
$subject_id   = $parts[1];
$topic_id     = $parts[2];
$content_type = $parts[3]; // e.g., videos, notes, quizzes

// === API URL (CORS bypass included) ===
$base_api = "https://api.pwthor.site/api/batch/"
          . urlencode($batch_id)
          . "/subject/" . urlencode($subject_id)
          . "/topic/"  . urlencode($topic_id)
          . "/all-contents?type=" . urlencode($content_type);

$real_url = "https://cors.hideme.eu.org/?url=" . $base_api;

// === HEADERS FOR API CALL ===
$headers = [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
    "Accept: application/json, text/plain, */*"
];

// === CURL REQUEST ===
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $real_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode([
        "success" => false,
        "error"   => "cURL error: " . curl_error($ch)
    ], JSON_PRETTY_PRINT);
    curl_close($ch);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// === HANDLE RESPONSE ===
if ($http_code !== 200) {
    echo json_encode([
        "success" => false,
        "error"   => "API request failed with HTTP code $http_code"
    ], JSON_PRETTY_PRINT);
    exit;
}

$data = json_decode($response, true);

if (json_last_error() === JSON_ERROR_NONE) {
    echo json_encode([
        "success" => true,
        "data"    => $data
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "error"   => "Invalid JSON response from API",
        "raw"     => $response
    ], JSON_PRETTY_PRINT);
}
?>
